#
# $Id: inslang.py,v 1.1 2007/02/05 17:34:24 aehyvari Exp $
#
### start[./copyright-py.txt]
# Including data from file ./copyright-py.txt
# file opened
# Reading 755 bytes of data
# Start of include
#
# Copyright 2007 Antti Hyvrinen
#
# This file is part of GridJM.
#
# GridJM is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# GridJM is distributed in the hope that it will be useful, but
# WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with GridJM; if not, write to the Free Software Foundation,
# Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#

# End of include
### stop[./copyright-py.txt]

import sys


from string import *
import re
from yappsrt import *

class InslangScanner(Scanner):
    patterns = [
        ('"\\)"', re.compile('\\)')),
        ('"\\("', re.compile('\\(')),
        ('[ \t\n]+', re.compile('[ \t\n]+')),
        ('ATOM', re.compile('[a-z]+')),
        ('FLOAT', re.compile('[0-9]*\\.[0-9]*')),
        ('INTEGER', re.compile('[1-9][0-9]*')),
        ('NAME', re.compile('\\[[^]]*\\]')),
    ]
    def __init__(self, str):
        Scanner.__init__(self,None,['[ \t\n]+'],str)

class Inslang(Parser):
    def start(self):
        term = self.term()
        self.tree = term

    def list(self):
        tlist = []
        self._scan('"\\("')
        while self._peek() != '"\\)"':
            term = self.term()
            tlist.append(term)
        self._scan('"\\)"')
        return tlist

    def term(self):
        _token_ = self._peek('"\\("', 'ATOM', 'NAME', 'FLOAT', 'INTEGER')
        if _token_ == '"\\("':
            list = self.list()
            return list
        elif _token_ == 'ATOM':
            ATOM = self._scan('ATOM')
            return ATOM
        elif _token_ == 'NAME':
            NAME = self._scan('NAME')
            return NAME
        elif _token_ == 'FLOAT':
            FLOAT = self._scan('FLOAT')
            return float(FLOAT)
        else:# == 'INTEGER'
            INTEGER = self._scan('INTEGER')
            return str(INTEGER)


def parse(rule, text):
    P = Inslang(InslangScanner(text))
    return wrap_error_reporter(P, rule)



def printtree(tree, indent):

    if not isinstance(tree, list):
        print indent + str(tree)
    else:
        for k in tree:
            printtree(k, indent + " ")

if __name__ == '__main__':
    file = open(sys.argv[1], 'r')
    text = file.read()
    rv, P = parse('start', text)
    printtree(P.tree, "")
