/* $Id$ */
/* User side communication module. (c) Antti Hyvrinen 2007 */
#include <queue>
#include <list>
#include <pthread.h>
#include <signal.h>
#include "common.h"

/* Find sensible values for these: */
#define BUFSIZE 1024 // The initial size for the xrsl buffer
#define READSIZE 1024 // The size of socket reads

void *user_listener(void *pointer);

class UserSide {
    public:
        UserSide(struct arguments *a, int pipe_read,
                queue<char*> *new_jobs, pthread_mutex_t *new_jobs_lock,
                list<PidJob*> *forked_downloads,
                pthread_mutex_t *forked_dl_lock,
                sigset_t *sigmask, sigset_t *orig_sigmask);
        int start(); 
        /* Args an Listen are public so that thread bootstrapper can
         * find it. Does it really matter?
         */
        struct arguments *args;
        int Listen(bool uds);
    private:
        int HandleConnection(int socket_hanlde);
        void GetMoreJobs();
        void InsertXrsl(char *buf);
        void RequestJob(char *buf);
        void WaitPids();
        pthread_mutex_t *new_jobs_lock;
        int *num_current_jobs;
        list<PidJob*> *forked_downloads;
        pthread_mutex_t *forked_dl_lock;
        queue<char*> *new_jobs;
        sigset_t *sigmask;
        sigset_t *orig_sigmask;
        fd_set *rfds;
        int pipe_read;
        int xrslsocket;
};
