
def partition(table, low, high, key):
    pivot_item = table[low]
    left = low
    pivot = left
    right = high
    while (left < right):
        while left < len(table) and (table[left][key] <= pivot_item[key]):
            left += 1

        while (table[right][key] > pivot_item[key]):
            right -= 1
        if (left < right): # Swap
            tmp = table[left]
            table[left] = table[right]
            table[right] = tmp
    table[low] = table[right]
    table[right] = pivot_item
    return right

def quicksort(table, low, high, key):
    pivot = 0
    if (high > low):
        pivot = partition(table, low, high, key)
        quicksort(table, low, pivot - 1, key)
        quicksort(table, pivot + 1, high, key)


def sortbykey(table, key):
    quicksort(table, 0, len(table) - 1, key)

