#include <string>
#include <fstream>
#include <list>
#include <assert.h>
#include <unistd.h>
#include <time.h>
using namespace std;

/**
 * successfull - First submission ran until the successfull finished
 *               state
 * resubmit    - After at least one failed submission, the submission
 *               ran untill the successfull finished state
 * failed      - Resubmission count was surpassed and the job was
 *              abandonned
 * submitfail  - Job submission failed (crowded grid or so)
 */
enum event_t {
    successfull,
    resubmit,
    failed,
    submitfail,
    undef
};

class EvType {
    public:
        EvType() : start(0), stop(0), name("uninit"), type(undef),
                   resubmitted(false) {};
        int start;
        int stop;
        string name; // The name of the job causing event
        event_t type; // Type of the event
        string typeStr();
        bool isresubmitted();
        bool resubmitted;
};

class Instrumenter {
    public:
        Instrumenter(string filename);
        ~Instrumenter();
        void simstart(string evname);
        void simstop(string evname, event_t type);
        void tofile();
        /* A change in event, such as the event was resubmitted */
        bool evchange(string evname, event_t type);
    private:
        string filename;
        ofstream output; // Output filename's file descriptor
        list<EvType*> simevents;
        int firstentry;
        int lastentry;
        int GetTime();
};
