#
# $Id$
#

import sys


from string import *
import re
from yappsrt import *

class InslangScanner(Scanner):
    patterns = [
        ('"\\)"', re.compile('\\)')),
        ('"\\("', re.compile('\\(')),
        ('[ \t\n]+', re.compile('[ \t\n]+')),
        ('ATOM', re.compile('[a-z]+')),
        ('FLOAT', re.compile('[0-9]*\\.[0-9]*')),
        ('INTEGER', re.compile('[1-9][0-9]*')),
        ('NAME', re.compile('\\[[^]]*\\]')),
    ]
    def __init__(self, str):
        Scanner.__init__(self,None,['[ \t\n]+'],str)

class Inslang(Parser):
    def start(self):
        term = self.term()
        self.tree = term

    def list(self):
        tlist = []
        self._scan('"\\("')
        while self._peek() != '"\\)"':
            term = self.term()
            tlist.append(term)
        self._scan('"\\)"')
        return tlist

    def term(self):
        _token_ = self._peek('"\\("', 'ATOM', 'NAME', 'FLOAT', 'INTEGER')
        if _token_ == '"\\("':
            list = self.list()
            return list
        elif _token_ == 'ATOM':
            ATOM = self._scan('ATOM')
            return ATOM
        elif _token_ == 'NAME':
            NAME = self._scan('NAME')
            return NAME
        elif _token_ == 'FLOAT':
            FLOAT = self._scan('FLOAT')
            return float(FLOAT)
        else:# == 'INTEGER'
            INTEGER = self._scan('INTEGER')
            return str(INTEGER)


def parse(rule, text):
    P = Inslang(InslangScanner(text))
    return wrap_error_reporter(P, rule)



def printtree(tree, indent):

    if not isinstance(tree, list):
        print indent + str(tree)
    else:
        for k in tree:
            printtree(k, indent + " ")

if __name__ == '__main__':
    file = open(sys.argv[1], 'r')
    text = file.read()
    rv, P = parse('start', text)
    printtree(P.tree, "")
