#!/usr/bin/env python
import sys
import os.path
import re

numunknowns = 0

class NoOutputError(Exception):
    def __init__(self, dldir):
        self.dldir = dldir

    def __str__(self):
        return self.dldir

class Construct:
    def __init__(self, dldir):
        output = os.path.join(dldir, "satjob.out-pr")
        output2 = os.path.join(dldir, "satjob.out")
        output3 = os.path.join(dldir, "haxor.out-pr") # test
        cpuinfo = os.path.join(dldir, "cpuinfo")
        diag = os.path.join(dldir, "gridlog/diag")

        try:
            output = open(output).read()
        except IOError, e:
            try:
                output = open(output2).read()
            except IOError, e2:
                try:
                    output = open(output3).read()
                except IOError, e3:
                    print e # This is fatal
                    print e2
                    raise NoOutputError("No solver output in " + dldir)

        try:
            cpuinfo = open(cpuinfo).read()
        except IOError, e:
            cpuinfo = ""
            print e # This is ok

        try:
            diag = open(diag).read()
        except IOError, e:
            diag = ""
            print e # This is too

        # Now we have read the information. Then we need to parse it

#        mo = re.search("Total Run Time[ \t]*([0-9\.]*)$", output, re.M)
	mo = re.search("KernelTime=([0-9\.]*)", diag, re.M)
        if mo:
            self.runtime = float(mo.group(1))
        else:
            raise NoOutputError("No kernel run time in " + dldir)

	mo = re.search("UserTime=([0-9\.]*)", diag, re.M)
	if mo:
	    self.runtime += float(mo.group(1))
	else:
	    raise NoOutputError("No user run time in " + dldir)

        mo = re.search("^jobname = (.*)", output, re.M)
        if mo:
            self.jobname = mo.group(1)
        else:
            self.jobname = "['unknown', -1]"
#            self.jobname = "['unknown', " + numunknowns + "]"
#            numunknowns += 1

if __name__ == '__main__':
    if len(sys.argv) != 2:
        print "Usage:", sys.argv[0], "dldir"
        sys.exit(1)
    else:
        Construct(sys.argv[1])

else:
    print "Parse by running", __name__ + ".Construct(dldir)"
