#define MAXSTATUSLENGTH 17      // Bad style...
#define RESUBMIT_ATTEMPTS 1
#include <time.h>

using namespace std;

class JobStatus {

    public:
        /**
         * Constructer - takes xrsl string and job id
         */
        JobStatus(Xrsl* xrsl, URL *jobid);

        /**
         * Destructer
         */
        ~JobStatus();

        /**
         * Returns the xrsl of the jobs
         */
        Xrsl* getXrsl();

        /**
         * Returns the job id of the job
         */
        URL *getJobid();

        /**
         * Returns the number resubmissions attempts
         */
        int getAttempts();

        /**
         * Returns the previous status of the job, which is one of
                 *
         * ACCEPTED CANCELING DELETED FINISHED FINISHING INLRMS NUM
                 * PREPARING SUBMITING UNDEFINED
         *
         * or something...
         */
        string getPrevStatus();

        /**
         * Returns the time (since the epoch, in seconds) the
         * status was last changed.
         */
                time_t getPrevTime();
        /**
         * Set new job status
         */
        void setNewStatus(string s);
        /**
         * Updates the object with new information about a submission
         * The old cluster is put into the cluster vector, the
         * current jobid is set to the new jobid and the number
         * of attempts is incremented by 1
         */
        void newSubmission(URL *new_jobid);
    private:
        int attempts;              // Number of submission attempts
        URL *current_jobid;        // Current jobid
        Xrsl* xrsl;                // Xrsl string to create object from
        vector <string> clusters;  // List of the cluster the job has been on
        string prev_status;        // Current status of job
        time_t prev_time;          // The time the status of job last changed
};

class GridJM {
    public:
        GridJM() : socketdir("/tmp/gridjm"), num_current_jobs(0),
                   s_timeout(600), clupd(0), clupdp(3600), xrslsocket(-1),
                   uds(1) {};
        ~GridJM() {};
        int Listen();
        int NetListen();
        int start();
        bool uds; // Use uds socket
    private:
        int maxgridjobs;
        int update_interval;
        void mainloop();
        void UpdateJobStatus();
        void HandleNewJobs();
        void HandleConnection(int socket_handle);
        URL *SubmitJob(Xrsl* xrsl);
        void GetMoreJobs();
        bool HandleJobFailure(string jobname);
        void FetchJob(string jobname);
        string socketdir;
        pthread_mutex_t current_jobs_lock;
        pthread_mutex_t new_jobs_lock;
        bool running;
        list<pid_t> forked_downloads;
        int xrslsocket;
        queue<Xrsl*> new_jobs;
        map<string, JobStatus*> current_jobs;
        int num_current_jobs;
        int s_timeout; // State wait timeout
        time_t clupd;   // Last time cluster list was updated
        time_t clupdp;  // Cluster update period in seconds
        list<URL> clusters;
};

void *uds_listener(void *pointer);


